/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.bson.codecs;

import com.dimensionrogue.libs.bson.BsonReader;
import com.dimensionrogue.libs.bson.BsonWriter;
import com.dimensionrogue.libs.bson.codecs.Codec;
import com.dimensionrogue.libs.bson.codecs.DecoderContext;
import com.dimensionrogue.libs.bson.codecs.EncoderContext;
import com.dimensionrogue.libs.bson.json.JsonObject;
import com.dimensionrogue.libs.bson.json.JsonReader;
import com.dimensionrogue.libs.bson.json.JsonWriter;
import com.dimensionrogue.libs.bson.json.JsonWriterSettings;
import java.io.StringWriter;

public class JsonObjectCodec
implements Codec<JsonObject> {
    private final JsonWriterSettings writerSettings;

    public JsonObjectCodec() {
        this(JsonWriterSettings.builder().build());
    }

    public JsonObjectCodec(JsonWriterSettings writerSettings) {
        this.writerSettings = writerSettings;
    }

    @Override
    public void encode(BsonWriter writer, JsonObject value, EncoderContext encoderContext) {
        writer.pipe(new JsonReader(value.getJson()));
    }

    @Override
    public JsonObject decode(BsonReader reader, DecoderContext decoderContext) {
        StringWriter stringWriter = new StringWriter();
        new JsonWriter(stringWriter, this.writerSettings).pipe(reader);
        return new JsonObject(stringWriter.toString());
    }

    @Override
    public Class<JsonObject> getEncoderClass() {
        return JsonObject.class;
    }
}

