/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.bson.codecs;

import com.dimensionrogue.libs.bson.Transformer;
import com.dimensionrogue.libs.bson.assertions.Assertions;
import com.dimensionrogue.libs.bson.codecs.BsonTypeClassMap;
import com.dimensionrogue.libs.bson.codecs.Codec;
import com.dimensionrogue.libs.bson.codecs.CollectionCodec;
import com.dimensionrogue.libs.bson.codecs.ContainerCodecHelper;
import com.dimensionrogue.libs.bson.codecs.ParameterizedCollectionCodec;
import com.dimensionrogue.libs.bson.codecs.configuration.CodecConfigurationException;
import com.dimensionrogue.libs.bson.codecs.configuration.CodecProvider;
import com.dimensionrogue.libs.bson.codecs.configuration.CodecRegistry;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class CollectionCodecProvider
implements CodecProvider {
    private final BsonTypeClassMap bsonTypeClassMap;
    private final Transformer valueTransformer;

    public CollectionCodecProvider() {
        this(BsonTypeClassMap.DEFAULT_BSON_TYPE_CLASS_MAP);
    }

    public CollectionCodecProvider(Transformer valueTransformer) {
        this(BsonTypeClassMap.DEFAULT_BSON_TYPE_CLASS_MAP, valueTransformer);
    }

    public CollectionCodecProvider(BsonTypeClassMap bsonTypeClassMap) {
        this(bsonTypeClassMap, null);
    }

    public CollectionCodecProvider(BsonTypeClassMap bsonTypeClassMap, Transformer valueTransformer) {
        this.bsonTypeClassMap = Assertions.notNull("bsonTypeClassMap", bsonTypeClassMap);
        this.valueTransformer = valueTransformer;
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        return this.get(clazz, Collections.emptyList(), registry);
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, List<Type> typeArguments, CodecRegistry registry) {
        if (Collection.class.isAssignableFrom(clazz)) {
            int typeArgumentsSize = typeArguments.size();
            switch (typeArgumentsSize) {
                case 0: {
                    CollectionCodec<T> result = new CollectionCodec<T>(registry, this.bsonTypeClassMap, this.valueTransformer, clazz);
                    return result;
                }
                case 1: {
                    ParameterizedCollectionCodec result = new ParameterizedCollectionCodec(ContainerCodecHelper.getCodec(registry, typeArguments.get(0)), clazz);
                    return result;
                }
            }
            throw new CodecConfigurationException("Expected only one type argument for a Collection, but found " + typeArgumentsSize);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollectionCodecProvider that = (CollectionCodecProvider)o;
        if (!this.bsonTypeClassMap.equals(that.bsonTypeClassMap)) {
            return false;
        }
        return Objects.equals(this.valueTransformer, that.valueTransformer);
    }

    public int hashCode() {
        return Objects.hash(this.bsonTypeClassMap, this.valueTransformer);
    }

    public String toString() {
        return "CollectionCodecProvider{}";
    }
}

