/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.bson.codecs;

import com.dimensionrogue.libs.bson.BsonInvalidOperationException;
import com.dimensionrogue.libs.bson.BsonReader;
import com.dimensionrogue.libs.bson.BsonWriter;
import com.dimensionrogue.libs.bson.assertions.Assertions;
import com.dimensionrogue.libs.bson.codecs.Codec;
import com.dimensionrogue.libs.bson.codecs.DecoderContext;
import com.dimensionrogue.libs.bson.codecs.EncoderContext;

public class CharacterCodec
implements Codec<Character> {
    @Override
    public void encode(BsonWriter writer, Character value, EncoderContext encoderContext) {
        Assertions.notNull("value", value);
        writer.writeString(value.toString());
    }

    @Override
    public Character decode(BsonReader reader, DecoderContext decoderContext) {
        String string = reader.readString();
        if (string.length() != 1) {
            throw new BsonInvalidOperationException(String.format("Attempting to decode the string '%s' to a character, but its length is not equal to one", string));
        }
        return Character.valueOf(string.charAt(0));
    }

    @Override
    public Class<Character> getEncoderClass() {
        return Character.class;
    }
}

