/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.bson.codecs;

import com.dimensionrogue.libs.bson.BsonInvalidOperationException;
import com.dimensionrogue.libs.bson.BsonReader;
import com.dimensionrogue.libs.bson.BsonWriter;
import com.dimensionrogue.libs.bson.codecs.Codec;
import com.dimensionrogue.libs.bson.codecs.DecoderContext;
import com.dimensionrogue.libs.bson.codecs.EncoderContext;
import com.dimensionrogue.libs.bson.codecs.NumberCodecHelper;

public class ByteCodec
implements Codec<Byte> {
    @Override
    public void encode(BsonWriter writer, Byte value, EncoderContext encoderContext) {
        writer.writeInt32(value.byteValue());
    }

    @Override
    public Byte decode(BsonReader reader, DecoderContext decoderContext) {
        int value = NumberCodecHelper.decodeInt(reader);
        if (value < -128 || value > 127) {
            throw new BsonInvalidOperationException(String.format("%s can not be converted into a Byte.", value));
        }
        return (byte)value;
    }

    @Override
    public Class<Byte> getEncoderClass() {
        return Byte.class;
    }
}

