/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.bson.codecs;

import com.dimensionrogue.libs.bson.BsonArray;
import com.dimensionrogue.libs.bson.BsonBinary;
import com.dimensionrogue.libs.bson.BsonBoolean;
import com.dimensionrogue.libs.bson.BsonDateTime;
import com.dimensionrogue.libs.bson.BsonDbPointer;
import com.dimensionrogue.libs.bson.BsonDecimal128;
import com.dimensionrogue.libs.bson.BsonDocument;
import com.dimensionrogue.libs.bson.BsonDocumentWrapper;
import com.dimensionrogue.libs.bson.BsonDouble;
import com.dimensionrogue.libs.bson.BsonInt32;
import com.dimensionrogue.libs.bson.BsonInt64;
import com.dimensionrogue.libs.bson.BsonJavaScript;
import com.dimensionrogue.libs.bson.BsonJavaScriptWithScope;
import com.dimensionrogue.libs.bson.BsonMaxKey;
import com.dimensionrogue.libs.bson.BsonMinKey;
import com.dimensionrogue.libs.bson.BsonNull;
import com.dimensionrogue.libs.bson.BsonObjectId;
import com.dimensionrogue.libs.bson.BsonRegularExpression;
import com.dimensionrogue.libs.bson.BsonString;
import com.dimensionrogue.libs.bson.BsonSymbol;
import com.dimensionrogue.libs.bson.BsonTimestamp;
import com.dimensionrogue.libs.bson.BsonType;
import com.dimensionrogue.libs.bson.BsonUndefined;
import com.dimensionrogue.libs.bson.BsonValue;
import com.dimensionrogue.libs.bson.RawBsonDocument;
import com.dimensionrogue.libs.bson.codecs.BsonArrayCodec;
import com.dimensionrogue.libs.bson.codecs.BsonBinaryCodec;
import com.dimensionrogue.libs.bson.codecs.BsonBooleanCodec;
import com.dimensionrogue.libs.bson.codecs.BsonDBPointerCodec;
import com.dimensionrogue.libs.bson.codecs.BsonDateTimeCodec;
import com.dimensionrogue.libs.bson.codecs.BsonDecimal128Codec;
import com.dimensionrogue.libs.bson.codecs.BsonDocumentCodec;
import com.dimensionrogue.libs.bson.codecs.BsonDocumentWrapperCodec;
import com.dimensionrogue.libs.bson.codecs.BsonDoubleCodec;
import com.dimensionrogue.libs.bson.codecs.BsonInt32Codec;
import com.dimensionrogue.libs.bson.codecs.BsonInt64Codec;
import com.dimensionrogue.libs.bson.codecs.BsonJavaScriptCodec;
import com.dimensionrogue.libs.bson.codecs.BsonJavaScriptWithScopeCodec;
import com.dimensionrogue.libs.bson.codecs.BsonMaxKeyCodec;
import com.dimensionrogue.libs.bson.codecs.BsonMinKeyCodec;
import com.dimensionrogue.libs.bson.codecs.BsonNullCodec;
import com.dimensionrogue.libs.bson.codecs.BsonObjectIdCodec;
import com.dimensionrogue.libs.bson.codecs.BsonRegularExpressionCodec;
import com.dimensionrogue.libs.bson.codecs.BsonStringCodec;
import com.dimensionrogue.libs.bson.codecs.BsonSymbolCodec;
import com.dimensionrogue.libs.bson.codecs.BsonTimestampCodec;
import com.dimensionrogue.libs.bson.codecs.BsonTypeClassMap;
import com.dimensionrogue.libs.bson.codecs.BsonUndefinedCodec;
import com.dimensionrogue.libs.bson.codecs.BsonValueCodec;
import com.dimensionrogue.libs.bson.codecs.Codec;
import com.dimensionrogue.libs.bson.codecs.RawBsonDocumentCodec;
import com.dimensionrogue.libs.bson.codecs.configuration.CodecProvider;
import com.dimensionrogue.libs.bson.codecs.configuration.CodecRegistry;
import java.util.HashMap;
import java.util.Map;

public class BsonValueCodecProvider
implements CodecProvider {
    private static final BsonTypeClassMap DEFAULT_BSON_TYPE_CLASS_MAP;
    private final Map<Class<?>, Codec<?>> codecs = new HashMap();

    public BsonValueCodecProvider() {
        this.addCodecs();
    }

    public static Class<? extends BsonValue> getClassForBsonType(BsonType bsonType) {
        return DEFAULT_BSON_TYPE_CLASS_MAP.get(bsonType);
    }

    public static BsonTypeClassMap getBsonTypeClassMap() {
        return DEFAULT_BSON_TYPE_CLASS_MAP;
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        if (this.codecs.containsKey(clazz)) {
            return this.codecs.get(clazz);
        }
        if (clazz == BsonJavaScriptWithScope.class) {
            return new BsonJavaScriptWithScopeCodec(registry.get(BsonDocument.class));
        }
        if (clazz == BsonValue.class) {
            return new BsonValueCodec(registry);
        }
        if (clazz == BsonDocumentWrapper.class) {
            return new BsonDocumentWrapperCodec(registry.get(BsonDocument.class));
        }
        if (clazz == RawBsonDocument.class) {
            return new RawBsonDocumentCodec();
        }
        if (BsonDocument.class.isAssignableFrom(clazz)) {
            return new BsonDocumentCodec(registry);
        }
        if (BsonArray.class.isAssignableFrom(clazz)) {
            return new BsonArrayCodec(registry);
        }
        return null;
    }

    private void addCodecs() {
        this.addCodec(new BsonNullCodec());
        this.addCodec(new BsonBinaryCodec());
        this.addCodec(new BsonBooleanCodec());
        this.addCodec(new BsonDateTimeCodec());
        this.addCodec(new BsonDBPointerCodec());
        this.addCodec(new BsonDoubleCodec());
        this.addCodec(new BsonInt32Codec());
        this.addCodec(new BsonInt64Codec());
        this.addCodec(new BsonDecimal128Codec());
        this.addCodec(new BsonMinKeyCodec());
        this.addCodec(new BsonMaxKeyCodec());
        this.addCodec(new BsonJavaScriptCodec());
        this.addCodec(new BsonObjectIdCodec());
        this.addCodec(new BsonRegularExpressionCodec());
        this.addCodec(new BsonStringCodec());
        this.addCodec(new BsonSymbolCodec());
        this.addCodec(new BsonTimestampCodec());
        this.addCodec(new BsonUndefinedCodec());
    }

    private <T extends BsonValue> void addCodec(Codec<T> codec) {
        this.codecs.put(codec.getEncoderClass(), codec);
    }

    public String toString() {
        return "BsonValueCodecProvider{}";
    }

    static {
        HashMap map = new HashMap();
        map.put(BsonType.NULL, BsonNull.class);
        map.put(BsonType.ARRAY, BsonArray.class);
        map.put(BsonType.BINARY, BsonBinary.class);
        map.put(BsonType.BOOLEAN, BsonBoolean.class);
        map.put(BsonType.DATE_TIME, BsonDateTime.class);
        map.put(BsonType.DB_POINTER, BsonDbPointer.class);
        map.put(BsonType.DOCUMENT, BsonDocument.class);
        map.put(BsonType.DOUBLE, BsonDouble.class);
        map.put(BsonType.INT32, BsonInt32.class);
        map.put(BsonType.INT64, BsonInt64.class);
        map.put(BsonType.DECIMAL128, BsonDecimal128.class);
        map.put(BsonType.MAX_KEY, BsonMaxKey.class);
        map.put(BsonType.MIN_KEY, BsonMinKey.class);
        map.put(BsonType.JAVASCRIPT, BsonJavaScript.class);
        map.put(BsonType.JAVASCRIPT_WITH_SCOPE, BsonJavaScriptWithScope.class);
        map.put(BsonType.OBJECT_ID, BsonObjectId.class);
        map.put(BsonType.REGULAR_EXPRESSION, BsonRegularExpression.class);
        map.put(BsonType.STRING, BsonString.class);
        map.put(BsonType.SYMBOL, BsonSymbol.class);
        map.put(BsonType.TIMESTAMP, BsonTimestamp.class);
        map.put(BsonType.UNDEFINED, BsonUndefined.class);
        DEFAULT_BSON_TYPE_CLASS_MAP = new BsonTypeClassMap(map);
    }
}

