/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.bson;

import com.dimensionrogue.libs.bson.BsonBinaryReader;
import com.dimensionrogue.libs.bson.BsonType;
import com.dimensionrogue.libs.bson.BsonValue;
import com.dimensionrogue.libs.bson.RawBsonArray;
import com.dimensionrogue.libs.bson.RawBsonDocument;
import com.dimensionrogue.libs.bson.codecs.BsonValueCodecProvider;
import com.dimensionrogue.libs.bson.codecs.DecoderContext;
import com.dimensionrogue.libs.bson.codecs.configuration.CodecRegistries;
import com.dimensionrogue.libs.bson.codecs.configuration.CodecRegistry;
import com.dimensionrogue.libs.bson.io.BsonInputMark;

final class RawBsonValueHelper {
    private static final CodecRegistry REGISTRY = CodecRegistries.fromProviders(new BsonValueCodecProvider());

    static BsonValue decode(byte[] bytes, BsonBinaryReader bsonReader) {
        if (bsonReader.getCurrentBsonType() == BsonType.DOCUMENT || bsonReader.getCurrentBsonType() == BsonType.ARRAY) {
            int position = bsonReader.getBsonInput().getPosition();
            BsonInputMark mark = bsonReader.getBsonInput().getMark(4);
            int size = bsonReader.getBsonInput().readInt32();
            mark.reset();
            bsonReader.skipValue();
            if (bsonReader.getCurrentBsonType() == BsonType.DOCUMENT) {
                return new RawBsonDocument(bytes, position, size);
            }
            return new RawBsonArray(bytes, position, size);
        }
        return (BsonValue)REGISTRY.get(BsonValueCodecProvider.getClassForBsonType(bsonReader.getCurrentBsonType())).decode(bsonReader, DecoderContext.builder().build());
    }

    private RawBsonValueHelper() {
    }
}

