/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.guis;

import com.dimensionrogue.DimensionRogue;
import java.util.Arrays;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ShopGUI
implements InventoryHolder {
    private final Inventory inventory;
    private final DimensionRogue plugin;

    public ShopGUI(DimensionRogue plugin) {
        this.plugin = plugin;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)54, (Component)Component.text((String)"\u00a78Dimension Shop"));
        this.initializeItems();
    }

    private void initializeItems() {
        this.setItem(10, Material.DIAMOND_SWORD, "\u00a7cCombat", "\u00a77Weapons and Armor");
        this.setItem(12, Material.GRASS_BLOCK, "\u00a7aBlocks", "\u00a77Building materials");
        this.setItem(14, Material.POTION, "\u00a7dConsumables", "\u00a77Potions and Food");
        this.setItem(16, Material.NETHER_STAR, "\u00a76Rare", "\u00a77Special items");
        ItemStack filler = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta meta = filler.getItemMeta();
        meta.displayName((Component)Component.text((String)" "));
        filler.setItemMeta(meta);
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            if (this.inventory.getItem(i) != null) continue;
            this.inventory.setItem(i, filler);
        }
    }

    private void setItem(int slot, Material material, String name, String ... lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.displayName((Component)Component.text((String)name));
        meta.lore(Arrays.stream(lore).map(Component::text).toList());
        item.setItemMeta(meta);
        this.inventory.setItem(slot, item);
    }

    public void open(Player player) {
        player.openInventory(this.inventory);
    }

    public Inventory getInventory() {
        return this.inventory;
    }
}

