/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.guis;

import com.dimensionrogue.DimensionRogue;
import java.util.Arrays;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class AdminGUI
implements InventoryHolder {
    private final Inventory inventory;
    private final DimensionRogue plugin;

    public AdminGUI(DimensionRogue plugin) {
        this.plugin = plugin;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)27, (Component)Component.text((String)"\u00a7c\u00a7lAdmin Panel"));
        this.initializeItems();
    }

    private void initializeItems() {
        this.setItem(10, Material.CLOCK, "\u00a7eTime Set Day", "\u00a77Click to set time to day");
        this.setItem(11, Material.WITHER_SKELETON_SKULL, "\u00a75Spawn Void King", "\u00a77Click to spawn Void King boss");
        this.setItem(12, Material.BLAZE_POWDER, "\u00a76Spawn Flame Lord", "\u00a77Click to spawn Flame Lord boss");
        this.setItem(14, Material.BARRIER, "\u00a7cBan Hammer", "\u00a77Click to view ban menu (WIP)");
        this.setItem(15, Material.COMMAND_BLOCK, "\u00a7bGameMode Creative", "\u00a77Click to switch to Creative");
        this.setItem(16, Material.GRASS_BLOCK, "\u00a7aGameMode Survival", "\u00a77Click to switch to Survival");
    }

    private void setItem(int slot, Material material, String name, String ... lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.displayName((Component)Component.text((String)name));
        meta.setLore(Arrays.asList((String[])Arrays.stream(lore).map(String::valueOf).toArray(String[]::new)));
        item.setItemMeta(meta);
        this.inventory.setItem(slot, item);
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public void handleClick(InventoryClickEvent event) {
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        switch (clicked.getType()) {
            case CLOCK: {
                player.getWorld().setTime(1000L);
                player.sendMessage("\u00a7aTime set to day.");
                break;
            }
            case WITHER_SKELETON_SKULL: {
                this.plugin.getBossManager().spawnBoss(player.getLocation(), "VOID_KING");
                player.sendMessage("\u00a75Void King spawned!");
                break;
            }
            case BLAZE_POWDER: {
                this.plugin.getBossManager().spawnBoss(player.getLocation(), "FLAME_LORD");
                player.sendMessage("\u00a76Flame Lord spawned!");
                break;
            }
            case COMMAND_BLOCK: {
                player.setGameMode(GameMode.CREATIVE);
                player.sendMessage("\u00a7bGamemode set to Creative.");
                break;
            }
            case GRASS_BLOCK: {
                player.setGameMode(GameMode.SURVIVAL);
                player.sendMessage("\u00a7aGamemode set to Survival.");
                break;
            }
            default: {
                player.sendMessage("\u00a7cFeature coming soon!");
            }
        }
    }
}

