/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.commands;

import com.dimensionrogue.DimensionRogue;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PartyCommand
implements CommandExecutor {
    private final DimensionRogue plugin;

    public PartyCommand(DimensionRogue plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        String sub;
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            player.sendMessage("\u00a7d\u00a7lPARTY");
            player.sendMessage("\u00a77/party create");
            player.sendMessage("\u00a77/party invite <player>");
            player.sendMessage("\u00a77/party accept");
            player.sendMessage("\u00a77/party leave");
            player.sendMessage("\u00a77/party chat <message>");
            return true;
        }
        switch (sub = args[0].toLowerCase()) {
            case "create": {
                this.plugin.getPartyManager().createParty(player);
                break;
            }
            case "accept": {
                this.plugin.getPartyManager().acceptInvite(player);
                break;
            }
            case "leave": {
                this.plugin.getPartyManager().leaveParty(player);
                break;
            }
            case "chat": {
                if (args.length < 2) {
                    player.sendMessage("\u00a7cUsage: /party chat <message>");
                    return true;
                }
                String msg = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
                this.plugin.getPartyManager().chat(player, msg);
                break;
            }
            case "invite": {
                if (args.length < 2) {
                    player.sendMessage("\u00a7cUsage: /party invite <player>");
                    return true;
                }
                Player target = Bukkit.getPlayer((String)args[1]);
                if (target == null) {
                    player.sendMessage("\u00a7cPlayer not found.");
                    return true;
                }
                this.plugin.getPartyManager().invitePlayer(player, target);
            }
        }
        return true;
    }
}

