/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.commands;

import com.dimensionrogue.DimensionRogue;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class LobbyCommand
implements CommandExecutor {
    private final DimensionRogue plugin;

    public LobbyCommand(DimensionRogue plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.plugin.getLobbyManager().sendToLobby(player);
            return true;
        }
        if (!player.hasPermission("demo.admin") && !player.isOp()) {
            player.sendMessage("\u00a7cYou don't have permission to use this command.");
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "setspawn": {
                Location loc = player.getLocation();
                this.plugin.getConfig().set("lobby.spawn.x", (Object)loc.getX());
                this.plugin.getConfig().set("lobby.spawn.y", (Object)loc.getY());
                this.plugin.getConfig().set("lobby.spawn.z", (Object)loc.getZ());
                this.plugin.getConfig().set("lobby.spawn.yaw", (Object)Float.valueOf(loc.getYaw()));
                this.plugin.getConfig().set("lobby.spawn.pitch", (Object)Float.valueOf(loc.getPitch()));
                this.plugin.saveConfig();
                this.plugin.getLobbyManager().updateSpawnLocation();
                player.sendMessage("\u00a7aLobby spawn set to your current location!");
                player.sendMessage("\u00a77X: " + String.format("%.2f", loc.getX()) + " Y: " + String.format("%.2f", loc.getY()) + " Z: " + String.format("%.2f", loc.getZ()));
                break;
            }
            case "addnpc": {
                if (args.length < 2) {
                    player.sendMessage("\u00a7cUsage: /lobby addnpc <guide|shop|quest|blacksmith|portal>");
                    return true;
                }
                String npcType = args[1].toUpperCase();
                Location npcLoc = player.getLocation();
                String path = "lobby.npcs." + npcType.toLowerCase();
                this.plugin.getConfig().set(path + ".x", (Object)npcLoc.getX());
                this.plugin.getConfig().set(path + ".y", (Object)npcLoc.getY());
                this.plugin.getConfig().set(path + ".z", (Object)npcLoc.getZ());
                this.plugin.getConfig().set(path + ".yaw", (Object)Float.valueOf(npcLoc.getYaw()));
                this.plugin.saveConfig();
                player.sendMessage("\u00a7aNPC position saved for " + npcType + "!");
                player.sendMessage("\u00a77Reload the server or use /lobby reload to spawn it.");
                break;
            }
            case "removenpc": {
                this.plugin.getNPCManager().removeNearestNPC(player.getLocation(), 5.0);
                player.sendMessage("\u00a7aRemoved nearest NPC within 5 blocks.");
                break;
            }
            case "reload": {
                this.plugin.reloadConfig();
                this.plugin.getLobbyManager().updateSpawnLocation();
                this.plugin.getNPCManager().removeAllNPCs();
                this.plugin.getNPCManager().spawnLobbyNPCs();
                player.sendMessage("\u00a7aLobby configuration reloaded!");
                break;
            }
            default: {
                player.sendMessage("\u00a7cUsage:");
                player.sendMessage("\u00a77/lobby \u00a7f- Teleport to lobby");
                player.sendMessage("\u00a77/lobby setspawn \u00a7f- Set lobby spawn");
                player.sendMessage("\u00a77/lobby addnpc <type> \u00a7f- Add NPC at your location");
                player.sendMessage("\u00a77/lobby removenpc \u00a7f- Remove nearby NPC");
                player.sendMessage("\u00a77/lobby reload \u00a7f- Reload lobby config");
            }
        }
        return true;
    }
}

