/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.abilities.ultimate;

import com.dimensionrogue.DimensionRogue;
import com.dimensionrogue.abilities.Ability;
import com.dimensionrogue.abilities.AbilityType;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class TimeStop
extends Ability {
    public TimeStop(DimensionRogue plugin) {
        super(plugin, "time_stop", "Time Stop", "Freeze time for nearby enemies", AbilityType.ULTIMATE, 60000L, 100);
    }

    @Override
    public void execute(Player player, int level) {
        int duration = 3 + level;
        int radius = 10 + level * 2;
        Location center = player.getLocation();
        center.getWorld().spawnParticle(Particle.ENCHANT, center, 100, (double)radius, 2.0, (double)radius, 0.0);
        center.getWorld().playSound(center, Sound.BLOCK_BEACON_DEACTIVATE, 2.0f, 0.5f);
        for (Entity e : center.getWorld().getNearbyEntities(center, (double)radius, (double)radius, (double)radius)) {
            if (!(e instanceof LivingEntity) || e == player) continue;
            LivingEntity target = (LivingEntity)e;
            target.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, duration * 20, 255));
            target.addPotionEffect(new PotionEffect(PotionEffectType.JUMP_BOOST, duration * 20, 128));
            target.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, duration * 20, 1));
            target.getWorld().spawnParticle(Particle.SNOWFLAKE, target.getLocation().add(0.0, 1.0, 0.0), 20, 0.5, 1.0, 0.5, 0.0);
        }
        player.sendMessage("\u00a76\u00a7l\u23f3 TIME STOPPED FOR " + duration + "s!");
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            player.getWorld().playSound(player.getLocation(), Sound.BLOCK_BEACON_ACTIVATE, 2.0f, 1.5f);
            player.sendMessage("\u00a7eTime flows again...");
        }, (long)duration * 20L);
    }
}

