/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.abilities.movement;

import com.dimensionrogue.DimensionRogue;
import com.dimensionrogue.abilities.Ability;
import com.dimensionrogue.abilities.AbilityType;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class BlinkDash
extends Ability {
    public BlinkDash(DimensionRogue plugin) {
        super(plugin, "blink_dash", "Blink Dash", "Teleport forward instantly", AbilityType.MOVEMENT, 3000L, 20);
    }

    @Override
    public void execute(Player player, int level) {
        Location start = player.getLocation();
        Vector direction = start.getDirection().normalize();
        int distance = 8 + level * 2;
        Location target = start.clone().add(direction.multiply(distance));
        if (target.getBlock().getType().isSolid()) {
            target = start.clone().add(direction.multiply(2));
        }
        start.getWorld().spawnParticle(Particle.PORTAL, start.add(0.0, 1.0, 0.0), 30, 0.5, 1.0, 0.5, 0.1);
        start.getWorld().playSound(start, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.2f);
        target.setDirection(player.getLocation().getDirection());
        player.teleport(target);
        target.getWorld().spawnParticle(Particle.DRAGON_BREATH, target.add(0.0, 1.0, 0.0), 20, 0.5, 1.0, 0.5, 0.05);
        target.getWorld().playSound(target, Sound.ENTITY_ILLUSIONER_MIRROR_MOVE, 1.0f, 1.5f);
        player.sendMessage("\u00a7b\u26a1 Blinked!");
    }
}

