/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.abilities.attack;

import com.dimensionrogue.DimensionRogue;
import com.dimensionrogue.abilities.Ability;
import com.dimensionrogue.abilities.AbilityType;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class VoidSlash
extends Ability {
    public VoidSlash(DimensionRogue plugin) {
        super(plugin, "void_slash", "Void Slash", "Unleash a wave of void energy", AbilityType.ATTACK, 5000L, 30);
    }

    @Override
    public void execute(Player player, int level) {
        Location loc = player.getLocation().add(0.0, 1.5, 0.0);
        Vector dir = loc.getDirection().normalize();
        double damage = 5.0 + (double)level * 1.5;
        for (int i = 0; i < 5; ++i) {
            Location point = loc.clone().add(dir.clone().multiply(i + 1));
            point.getWorld().spawnParticle(Particle.SWEEP_ATTACK, point, 1);
            point.getWorld().spawnParticle(Particle.WITCH, point, 5, 0.5, 0.5, 0.5, 0.0);
            for (Entity e : point.getWorld().getNearbyEntities(point, 1.5, 1.5, 1.5)) {
                if (!(e instanceof LivingEntity) || e == player) continue;
                ((LivingEntity)e).damage(damage, (Entity)player);
            }
        }
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_PLAYER_ATTACK_SWEEP, 1.0f, 0.5f);
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_WITHER_SHOOT, 0.5f, 1.5f);
    }
}

