/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue;

import com.dimensionrogue.commands.AbilitiesCommand;
import com.dimensionrogue.commands.AdminCommand;
import com.dimensionrogue.commands.ArenaCommand;
import com.dimensionrogue.commands.BattlePassCommand;
import com.dimensionrogue.commands.CosmeticsCommand;
import com.dimensionrogue.commands.CurrencyCommand;
import com.dimensionrogue.commands.DimensionCommand;
import com.dimensionrogue.commands.FriendCommand;
import com.dimensionrogue.commands.LobbyCommand;
import com.dimensionrogue.commands.ParkourCommand;
import com.dimensionrogue.commands.PartyCommand;
import com.dimensionrogue.commands.QuestCommand;
import com.dimensionrogue.commands.RankCommand;
import com.dimensionrogue.commands.ShopCommand;
import com.dimensionrogue.database.DatabaseManager;
import com.dimensionrogue.listeners.BlockListener;
import com.dimensionrogue.listeners.ChatListener;
import com.dimensionrogue.listeners.DimensionListener;
import com.dimensionrogue.listeners.EntityListener;
import com.dimensionrogue.listeners.InventoryListener;
import com.dimensionrogue.listeners.PlayerCombatListener;
import com.dimensionrogue.listeners.PlayerDeathListener;
import com.dimensionrogue.listeners.PlayerInteractListener;
import com.dimensionrogue.listeners.PlayerJoinListener;
import com.dimensionrogue.listeners.PlayerMoveListener;
import com.dimensionrogue.listeners.PlayerQuitListener;
import com.dimensionrogue.managers.AbilityManager;
import com.dimensionrogue.managers.AchievementManager;
import com.dimensionrogue.managers.AntiCheatManager;
import com.dimensionrogue.managers.BattlePassManager;
import com.dimensionrogue.managers.BossManager;
import com.dimensionrogue.managers.ChatManager;
import com.dimensionrogue.managers.CollisionManager;
import com.dimensionrogue.managers.CosmeticsManager;
import com.dimensionrogue.managers.CurrencyManager;
import com.dimensionrogue.managers.CustomItemManager;
import com.dimensionrogue.managers.DimensionManager;
import com.dimensionrogue.managers.EventManager;
import com.dimensionrogue.managers.FriendManager;
import com.dimensionrogue.managers.LeaderboardManager;
import com.dimensionrogue.managers.LobbyManager;
import com.dimensionrogue.managers.MobManager;
import com.dimensionrogue.managers.NPCManager;
import com.dimensionrogue.managers.ParkourManager;
import com.dimensionrogue.managers.PartyManager;
import com.dimensionrogue.managers.PlayerDataManager;
import com.dimensionrogue.managers.PortalManager;
import com.dimensionrogue.managers.PvPManager;
import com.dimensionrogue.managers.QuestManager;
import com.dimensionrogue.managers.RankManager;
import com.dimensionrogue.managers.ScoreboardManager;
import com.dimensionrogue.managers.ShopManager;
import com.dimensionrogue.managers.TabListManager;
import com.dimensionrogue.managers.TutorialManager;
import com.dimensionrogue.worlds.LobbyGenerator;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class DimensionRogue
extends JavaPlugin {
    private static DimensionRogue instance;
    private DatabaseManager databaseManager;
    private PlayerDataManager playerDataManager;
    private DimensionManager dimensionManager;
    private AbilityManager abilityManager;
    private CurrencyManager currencyManager;
    private CosmeticsManager cosmeticsManager;
    private MobManager mobManager;
    private BossManager bossManager;
    private PortalManager portalManager;
    private QuestManager questManager;
    private RankManager rankManager;
    private BattlePassManager battlePassManager;
    private ShopManager shopManager;
    private FriendManager friendManager;
    private PartyManager partyManager;
    private PvPManager pvpManager;
    private ParkourManager parkourManager;
    private EventManager eventManager;
    private AntiCheatManager antiCheatManager;
    private TutorialManager tutorialManager;
    private ChatManager chatManager;
    private ScoreboardManager scoreboardManager;
    private AchievementManager achievementManager;
    private LeaderboardManager leaderboardManager;
    private CollisionManager collisionManager;
    private LobbyManager lobbyManager;
    private CustomItemManager customItemManager;
    private NPCManager npcManager;
    private TabListManager tabListManager;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.getLogger().info("========================================");
        this.getLogger().info("  DIMENSION ROGUE - Starting...");
        this.getLogger().info("========================================");
        try {
            this.databaseManager = new DatabaseManager(this);
            this.getLogger().info("[\u2713] Database initialized");
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to initialize database!", e);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.initializeManagers();
        this.registerListeners();
        this.registerCommands();
        this.setupWorlds();
        this.startTasks();
        this.getLogger().info("========================================");
        this.getLogger().info("  DIMENSION ROGUE - Enabled!");
        this.getLogger().info("========================================");
    }

    public void onDisable() {
        this.getLogger().info("Saving all data...");
        if (this.playerDataManager != null) {
            this.playerDataManager.saveAllPlayers();
        }
        if (this.dimensionManager != null) {
            this.dimensionManager.saveAllDimensions();
        }
        if (this.databaseManager != null) {
            this.databaseManager.close();
        }
        this.getLogger().info("DIMENSION ROGUE - Disabled!");
    }

    private void initializeManagers() {
        this.getLogger().info("Initializing managers...");
        this.playerDataManager = new PlayerDataManager(this);
        this.currencyManager = new CurrencyManager(this);
        this.dimensionManager = new DimensionManager(this);
        this.abilityManager = new AbilityManager(this);
        this.cosmeticsManager = new CosmeticsManager(this);
        this.mobManager = new MobManager(this);
        this.bossManager = new BossManager(this);
        this.portalManager = new PortalManager(this);
        this.questManager = new QuestManager(this);
        this.rankManager = new RankManager(this);
        this.battlePassManager = new BattlePassManager(this);
        this.shopManager = new ShopManager(this);
        this.friendManager = new FriendManager(this);
        this.partyManager = new PartyManager(this);
        this.pvpManager = new PvPManager(this);
        this.parkourManager = new ParkourManager(this);
        this.eventManager = new EventManager(this);
        this.antiCheatManager = new AntiCheatManager(this);
        this.tutorialManager = new TutorialManager(this);
        this.chatManager = new ChatManager(this);
        this.scoreboardManager = new ScoreboardManager(this);
        this.achievementManager = new AchievementManager(this);
        this.leaderboardManager = new LeaderboardManager(this);
        this.collisionManager = new CollisionManager(this);
        this.customItemManager = new CustomItemManager(this);
        this.lobbyManager = new LobbyManager(this);
        this.npcManager = new NPCManager(this);
        this.tabListManager = new TabListManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)new DimensionListener(this), (Plugin)this);
        this.getLogger().info("[\u2713] Listeners registered");
    }

    private void registerListeners() {
        this.getLogger().info("Registering listeners...");
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerQuitListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerInteractListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerMoveListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerCombatListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BlockListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EntityListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ChatListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new DimensionListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerDeathListener(this), (Plugin)this);
        this.getLogger().info("[\u2713] Listeners registered");
    }

    private void registerCommands() {
        this.getLogger().info("Registering commands...");
        this.getCommand("dimension").setExecutor((CommandExecutor)new DimensionCommand(this));
        this.getCommand("abilities").setExecutor((CommandExecutor)new AbilitiesCommand(this));
        this.getCommand("shop").setExecutor((CommandExecutor)new ShopCommand(this));
        this.getCommand("cosmetics").setExecutor((CommandExecutor)new CosmeticsCommand(this));
        this.getCommand("friend").setExecutor((CommandExecutor)new FriendCommand(this));
        this.getCommand("party").setExecutor((CommandExecutor)new PartyCommand(this));
        this.getCommand("rank").setExecutor((CommandExecutor)new RankCommand(this));
        this.getCommand("battlepass").setExecutor((CommandExecutor)new BattlePassCommand(this));
        this.getCommand("quest").setExecutor((CommandExecutor)new QuestCommand(this));
        this.getCommand("arena").setExecutor((CommandExecutor)new ArenaCommand(this));
        this.getCommand("parkour").setExecutor((CommandExecutor)new ParkourCommand(this));
        this.getCommand("admin").setExecutor((CommandExecutor)new AdminCommand(this));
        this.getCommand("shards").setExecutor((CommandExecutor)new CurrencyCommand(this));
        this.getCommand("lobby").setExecutor((CommandExecutor)new LobbyCommand(this));
        this.getLogger().info("[\u2713] Commands registered");
    }

    private void setupWorlds() {
        this.getLogger().info("Setting up worlds...");
        String lobbyName = this.getConfig().getString("server.lobby-world", "lobby");
        World lobby = Bukkit.getWorld((String)lobbyName);
        if (lobby == null) {
            this.getLogger().info("Creating lobby world...");
            WorldCreator creator = new WorldCreator(lobbyName);
            creator.generator((ChunkGenerator)new LobbyGenerator());
            lobby = creator.createWorld();
            this.getLogger().info("[\u2713] Lobby world created");
        }
        if (lobby != null) {
            lobby.setSpawnLocation(0, 100, 0);
        }
        this.getLogger().info("[\u2713] Worlds setup complete");
    }

    private void startTasks() {
        this.getLogger().info("Starting tasks...");
        Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> this.portalManager.checkPortalSpawns(), 20L, 1200L);
        Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> this.dimensionManager.triggerRandomEvents(), 20L, 6000L);
        int saveInterval = this.getConfig().getInt("server.auto-save-interval", 300);
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> {
            this.playerDataManager.saveAllPlayers();
            this.dimensionManager.saveAllDimensions();
        }, 20L * (long)saveInterval, 20L * (long)saveInterval);
        Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> this.scoreboardManager.updateAllScoreboards(), 20L, 20L);
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> this.leaderboardManager.updateLeaderboards(), 100L, 1200L);
        Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> this.collisionManager.checkCollisions(), 20L, 12000L);
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
            this.npcManager.spawnLobbyNPCs();
            this.getLogger().info("[\u2713] Lobby NPCs spawned");
        }, 40L);
        this.getLogger().info("[\u2713] Tasks started");
    }

    public static DimensionRogue getInstance() {
        return instance;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public PlayerDataManager getPlayerDataManager() {
        return this.playerDataManager;
    }

    public DimensionManager getDimensionManager() {
        return this.dimensionManager;
    }

    public AbilityManager getAbilityManager() {
        return this.abilityManager;
    }

    public CurrencyManager getCurrencyManager() {
        return this.currencyManager;
    }

    public CosmeticsManager getCosmeticsManager() {
        return this.cosmeticsManager;
    }

    public MobManager getMobManager() {
        return this.mobManager;
    }

    public BossManager getBossManager() {
        return this.bossManager;
    }

    public PortalManager getPortalManager() {
        return this.portalManager;
    }

    public QuestManager getQuestManager() {
        return this.questManager;
    }

    public RankManager getRankManager() {
        return this.rankManager;
    }

    public BattlePassManager getBattlePassManager() {
        return this.battlePassManager;
    }

    public ShopManager getShopManager() {
        return this.shopManager;
    }

    public FriendManager getFriendManager() {
        return this.friendManager;
    }

    public PartyManager getPartyManager() {
        return this.partyManager;
    }

    public PvPManager getPvPManager() {
        return this.pvpManager;
    }

    public ParkourManager getParkourManager() {
        return this.parkourManager;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public AntiCheatManager getAntiCheatManager() {
        return this.antiCheatManager;
    }

    public TutorialManager getTutorialManager() {
        return this.tutorialManager;
    }

    public ChatManager getChatManager() {
        return this.chatManager;
    }

    public ScoreboardManager getScoreboardManager() {
        return this.scoreboardManager;
    }

    public AchievementManager getAchievementManager() {
        return this.achievementManager;
    }

    public LeaderboardManager getLeaderboardManager() {
        return this.leaderboardManager;
    }

    public CollisionManager getCollisionManager() {
        return this.collisionManager;
    }

    public LobbyManager getLobbyManager() {
        return this.lobbyManager;
    }

    public CustomItemManager getCustomItemManager() {
        return this.customItemManager;
    }

    public NPCManager getNPCManager() {
        return this.npcManager;
    }

    public TabListManager getTabListManager() {
        return this.tabListManager;
    }

    public ChunkGenerator getDefaultWorldGenerator(String worldName, String id) {
        this.getLogger().info("Requesting generator for world: " + worldName + " with id: " + id);
        if (id != null && id.equalsIgnoreCase("lobby")) {
            return new LobbyGenerator();
        }
        return null;
    }
}

